import { jsxs, jsx } from "react/jsx-runtime";
import { I as IconPickerDialog } from "./icon-picker-dialog-kwu88Bla.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { B as Button } from "./button-CoRGprmX.js";
import { D as Dialog, a as DialogTrigger, b as DialogContent, c as DialogHeader, d as DialogTitle, e as DialogFooter, f as DialogClose } from "./dialog-Bzzm0V8u.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { S as ScrollArea } from "./scroll-area-Dgj2o23v.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-DLRJE4Jo.js";
import { T as Textarea } from "./textarea-M8ToDCeU.js";
import { u as useLang } from "./use-lang-44ndmTOc.js";
import { o as onHandleChange } from "./inertia-BtwbgBI3.js";
import { useForm } from "@inertiajs/react";
import { useState } from "react";
import "./icon-picker-CUJAUhoK.js";
import "./debounce-ZFxqVthq.js";
import "lucide-react";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "lucide-react/dynamic";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "@radix-ui/react-dialog";
import "@radix-ui/react-label";
import "@radix-ui/react-scroll-area";
import "@radix-ui/react-select";
const CategoryForm = ({ title, category, handler }) => {
  const [open, setOpen] = useState(false);
  const { input, button } = useLang();
  const { data, setData, post, errors, processing, reset } = useForm({
    title: category ? category.title : "",
    icon: category ? category.icon : "",
    status: category ? category.status ? 1 : 0 : 1,
    description: category ? category.description : "",
    thumbnail: null
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    if (category) {
      post(route("exam-categories.update", category.id), {
        onSuccess: () => setOpen(false)
      });
    } else {
      post(route("exam-categories.store"), {
        onSuccess: () => {
          reset();
          setOpen(false);
        }
      });
    }
  };
  return /* @__PURE__ */ jsxs(Dialog, { open, onOpenChange: setOpen, children: [
    /* @__PURE__ */ jsx(DialogTrigger, { children: handler }),
    /* @__PURE__ */ jsx(DialogContent, { className: "p-0", children: /* @__PURE__ */ jsxs(ScrollArea, { className: "max-h-[90vh] p-6", children: [
      /* @__PURE__ */ jsx(DialogHeader, { className: "mb-6", children: /* @__PURE__ */ jsx(DialogTitle, { children: title }) }),
      /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-4 p-0.5", children: [
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: input.title }),
          /* @__PURE__ */ jsx(
            Input,
            {
              required: true,
              type: "text",
              name: "title",
              value: data.title,
              placeholder: input.title_placeholder,
              onChange: (e) => onHandleChange(e, setData)
            }
          ),
          /* @__PURE__ */ jsx(InputError, { message: errors.title })
        ] }),
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: input.category_icon }),
          /* @__PURE__ */ jsx(
            IconPickerDialog,
            {
              name: "icon",
              value: data.icon || "",
              placeholder: "Pick your category icon",
              onSelect: (icon) => setData("icon", icon)
            }
          ),
          /* @__PURE__ */ jsx(InputError, { message: errors.icon })
        ] }),
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: input.category_status }),
          /* @__PURE__ */ jsxs(Select, { value: data.status.toString(), onValueChange: (value) => setData("status", Number(value)), children: [
            /* @__PURE__ */ jsx(SelectTrigger, { children: /* @__PURE__ */ jsx(SelectValue, { placeholder: input.status_placeholder }) }),
            /* @__PURE__ */ jsxs(SelectContent, { children: [
              /* @__PURE__ */ jsx(SelectItem, { value: "1", children: "Active" }),
              /* @__PURE__ */ jsx(SelectItem, { value: "0", children: "Inactive" })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: input.description }),
          /* @__PURE__ */ jsx(
            Textarea,
            {
              name: "description",
              value: data.description,
              placeholder: input.description_placeholder,
              onChange: (e) => onHandleChange(e, setData)
            }
          ),
          /* @__PURE__ */ jsx(InputError, { message: errors.description })
        ] }),
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: input.thumbnail }),
          /* @__PURE__ */ jsx(Input, { type: "file", name: "thumbnail", accept: "image/*", onChange: (e) => {
            var _a;
            return setData("thumbnail", (_a = e.target.files) == null ? void 0 : _a[0]);
          } }),
          /* @__PURE__ */ jsx(InputError, { message: errors.thumbnail })
        ] }),
        /* @__PURE__ */ jsxs(DialogFooter, { className: "flex justify-end space-x-2 pt-4", children: [
          /* @__PURE__ */ jsx(DialogClose, { asChild: true, children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "outline", children: button.close }) }),
          /* @__PURE__ */ jsx(LoadingButton, { loading: processing, children: button.save_changes })
        ] })
      ] })
    ] }) })
  ] });
};
export {
  CategoryForm as default
};
